/*
 *  Written by: Charlie Tangora, NOT Brent Feulbach
 * 
 *  Modified by: Brent Feulbach
 *  Date: 20-Aug-2020
* 
 *  Note to whoever is marking this assignment.  This is not my code.  I do not
 *  claim credit for it with regards to my assignment
  */


#ifndef INC_GIF_H


#include <stdio.h>   // for FILE*
#include <string.h>  // for memcpy and bzero
#include <stdint.h>  // for integer typedefs

// Define these macros to hook into a custom memory allocator.
// TEMP_MALLOC and TEMP_FREE will only be called in stack fashion - frees in the reverse order of mallocs
// and any temp memory allocated by a function will be freed before it exits.
// MALLOC and FREE are used only by GifBegin and GifEnd respectively (to allocate a buffer the size of the image, which
// is used to find changed pixels for delta-encoding.)

#ifndef GIF_TEMP_MALLOC
#include <stdlib.h>
#define GIF_TEMP_MALLOC malloc
#endif

#ifndef GIF_TEMP_FREE
#include <stdlib.h>
#define GIF_TEMP_FREE free
#endif

#ifndef GIF_MALLOC
#include <stdlib.h>
#define GIF_MALLOC malloc
#endif

#ifndef GIF_FREE
#include <stdlib.h>
#define GIF_FREE free
#endif

typedef struct tagGifWriter
{
    FILE* f;
    uint8_t* oldImage;
    bool firstFrame;
}GifWriter;

#ifdef __cplusplus
extern "C" {
#endif

bool GifBegin( GifWriter* writer, const char* filename, uint32_t width, 
    uint32_t height, uint32_t delay);

bool GifWriteFrame( GifWriter* writer, const uint8_t* image, uint32_t width, 
    uint32_t height, uint32_t delay);

bool GifEnd( GifWriter* writer );

#ifdef __cplusplus
}
#endif



#define INC_GIF_H
#endif