#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#define CHAR_EOL    0x0A


char inBuf[1000000], outBuf[1000000],ch;
int inBufSize, outBufSize,wid=0, hgt=0,outBufPos, inBufPos = 0, col=0,row=0,i;
bool lineTerm = true;
FILE *inFile, *outFile;

int main(int argc, char **argv) {
 
    if (argc != 3) {
        fprintf(stderr,"usage: lex2map infile outfile\n");
        exit(1);
    }

    if ((inFile = fopen(argv[1],"rb"))==NULL) {
        fprintf(stderr,"cant open infile\n");
        exit(1);
    }
    inBufSize = fread((char*)inBuf,1,1000000,inFile);
    fclose(inFile);

    for(i=0;i<50;i++)
        outBuf[i] = ' ';
    outBuf[50] = CHAR_EOL;
    outBufPos = 51;

    while(inBufPos < inBufSize) {
        ch = inBuf[inBufPos++];
        if (ch == CHAR_EOL) {
            if (col >0) {
                wid = col;
                row++;
                hgt++;
            }
            col = 0;
            lineTerm = true;
            continue;
        }
        if (ch < ' ') {
            continue;
        }
        if ((ch == 'O')||(ch=='.')) {
            if (ch=='O') {
                outBufPos += sprintf(&outBuf[outBufPos],"[%u,%u]\n",col,row);
            }
            col++;
            lineTerm = false;
            continue;
        }
        fprintf(stderr,"Unexpected character '%c' (%2Xh)\n",(isprint(ch)?ch:' '),ch);
        exit(1);
    }
    if (!lineTerm) {
        hgt++;
    }
    i = sprintf((char*)outBuf,"[%lu,%lu] // map size",wid,hgt);
    outBuf[i] = ' ';

    if ((outFile = fopen(argv[2],"w+a")) == NULL) {
        fprintf(stderr,"cant open outfile\n");
        exit(1);
    }
    if (fwrite((char*)outBuf,1, outBufPos,outFile) != outBufPos) {
        fprintf(stderr,"problem writing to outfile\n");
        exit(1);
    }
    fclose(outFile);
    return 0;
}


